using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using Borland.Eco.Logging;
using Borland.Eco.Handles.Design;

namespace Borland.Eco.Examples.EcoSpaceDesignerPlugins
{
	///<summary>
	///This tool provides a visual entry to ECO logging facilities.
	///Using the tool will affect the logging in DESIGN TIME only.
	///To modify design time behaviour of logging you need to turn on the log switches
	///at run time AND install a listener.
	///</summary>
	[ToolboxBitmap(typeof(DesignTimeLogging), "Borland.Eco.Examples.EcoSpaceDesignerPlugins.DesignTimeLogging.bmp")]
	public class DesignTimeLogging: EcoToolButtonBase
	{
		///<summary>
		///Called by the IDE.
		///Used to register the tool.
		///</summary>
		public static void IDERegister()
		{
			EcoSpaceDesignerToolbox.AddTool(new DesignTimeLogging());
		}
		///<summary>
		///Part of the interface. In this case, we do not want the tool to automatically
		///request a recompile of the application being designed.
		///</summary>
		public override bool RequireRecompile()
		{
			return false;
		}
		///<summary>
		///Part of the interface.
		///This is what the tool is supposed to do:
		///* Create a form
		///* Set the checkboxes according to the current state of log switches
		///* Show the form modally
		///* Dispose of the form
		///</summary>
		public override void Execute(ExecuteArgs executeArgs)
		{
			DesignTimeLoggingForm f = new DesignTimeLoggingForm();
			f.SetCheckBoxes();
			f.ShowDialog();
			f.Dispose();
		}
		///<summary>
		///Part of the interface.
		///Returns the text for the tool.
		///</summary>
		public override string GetCaption()
		{
			return "&Control design time logging facilities";
		}
	 }
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class DesignTimeLoggingForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.CheckBox cbxOcl;
		private System.Windows.Forms.CheckBox cbxSql;
		private System.Windows.Forms.CheckBox cbxSqlMeta;
		private System.Windows.Forms.CheckBox cbxRegions;
		private System.Windows.Forms.CheckBox cbxPMapper;
		private System.Windows.Forms.CheckBox cbxValidation;
		private System.Windows.Forms.Button btnApply;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Button btnCancel;

		public DesignTimeLoggingForm()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DesignTimeLoggingForm));
			this.cbxOcl = new System.Windows.Forms.CheckBox();
			this.cbxSql = new System.Windows.Forms.CheckBox();
			this.cbxSqlMeta = new System.Windows.Forms.CheckBox();
			this.cbxRegions = new System.Windows.Forms.CheckBox();
			this.cbxPMapper = new System.Windows.Forms.CheckBox();
			this.cbxValidation = new System.Windows.Forms.CheckBox();
			this.btnApply = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			//
			// cbxOcl
			//
			this.cbxOcl.Location = new System.Drawing.Point(8, 16);
			this.cbxOcl.Name = "cbxOcl";
			this.cbxOcl.Size = new System.Drawing.Size(104, 16);
			this.cbxOcl.TabIndex = 0;
			this.cbxOcl.Text = "Ocl";
			//
			// cbxSql
			//
			this.cbxSql.Location = new System.Drawing.Point(8, 40);
			this.cbxSql.Name = "cbxSql";
			this.cbxSql.Size = new System.Drawing.Size(104, 16);
			this.cbxSql.TabIndex = 1;
			this.cbxSql.Text = "Sql";
			//
			// cbxSqlMeta
			//
			this.cbxSqlMeta.Location = new System.Drawing.Point(8, 64);
			this.cbxSqlMeta.Name = "cbxSqlMeta";
			this.cbxSqlMeta.Size = new System.Drawing.Size(152, 16);
			this.cbxSqlMeta.TabIndex = 2;
			this.cbxSqlMeta.Text = "Sql - meta statements";
			//
			// cbxRegions
			//
			this.cbxRegions.Location = new System.Drawing.Point(8, 88);
			this.cbxRegions.Name = "cbxRegions";
			this.cbxRegions.Size = new System.Drawing.Size(104, 16);
			this.cbxRegions.TabIndex = 3;
			this.cbxRegions.Text = "Regions";
			//
			// cbxPMapper
			//
			this.cbxPMapper.Location = new System.Drawing.Point(8, 112);
			this.cbxPMapper.Name = "cbxPMapper";
			this.cbxPMapper.Size = new System.Drawing.Size(200, 16);
			this.cbxPMapper.TabIndex = 4;
			this.cbxPMapper.Text = "Persistence mapper activities";
			//
			// cbxValidation
			//
			this.cbxValidation.Location = new System.Drawing.Point(8, 136);
			this.cbxValidation.Name = "cbxValidation";
			this.cbxValidation.Size = new System.Drawing.Size(176, 16);
			this.cbxValidation.TabIndex = 5;
			this.cbxValidation.Text = "Validation activities";
			//
			// btnApply
			//
			this.btnApply.Location = new System.Drawing.Point(8, 168);
			this.btnApply.Name = "btnApply";
			this.btnApply.TabIndex = 6;
			this.btnApply.Text = "&Apply";
			this.btnApply.Click += new System.EventHandler(this.btnApply_Click);
			//
			// btnOK
			//
			this.btnOK.Location = new System.Drawing.Point(88, 168);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 7;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			//
			// btnCancel
			//
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(168, 168);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 8;
			this.btnCancel.Text = "&Cancel";
			//
			// DesignTimeLoggingForm
			//
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(248, 198);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnApply);
			this.Controls.Add(this.cbxValidation);
			this.Controls.Add(this.cbxPMapper);
			this.Controls.Add(this.cbxRegions);
			this.Controls.Add(this.cbxSqlMeta);
			this.Controls.Add(this.cbxSql);
			this.Controls.Add(this.cbxOcl);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(256, 232);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(256, 232);
			this.Name = "DesignTimeLoggingForm";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Design time logging";
			this.ResumeLayout(false);
		}
		#endregion

		///<summary>
		///Apply the checkboxes' state to the log switches.
		///</summary>
		private void btnApply_Click(object sender, System.EventArgs e)
		{
			ApplyCheckBoxes();
		}

		///<summary>
		///Apply the checkboxes' state to the log switches and close the form.
		///</summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			ApplyCheckBoxes();
			Close();
		}
		///<summary>
		///Apply the checkboxes' state to the log switches.
		///</summary>
		private void ApplyCheckBoxes()
		{
			EcoLogSwitches.LogOcl = cbxOcl.Checked;
			EcoLogSwitches.LogSql = cbxSql.Checked;
			EcoLogSwitches.LogSqlMeta = cbxSqlMeta.Checked;
			EcoLogSwitches.LogRegions = cbxRegions.Checked;
			EcoLogSwitches.LogPMapper = cbxPMapper.Checked;
			EcoLogSwitches.LogValidation = cbxValidation.Checked;
		}
		///<summary>
		///Apply the log switches state to the checkboxes.
		///</summary>
		public void SetCheckBoxes()
		{
			cbxOcl.Checked = EcoLogSwitches.LogOcl;
			cbxSql.Checked = EcoLogSwitches.LogSql;
			cbxSqlMeta.Checked = EcoLogSwitches.LogSqlMeta;
			cbxRegions.Checked = EcoLogSwitches.LogRegions;
			cbxPMapper.Checked = EcoLogSwitches.LogPMapper;
			cbxValidation.Checked = EcoLogSwitches.LogValidation;
		}
	}
}